<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function sessions()
    {
        return $this->hasMany('App\Models\Session', 'user_id');
    }

    public function role()
    {
        return $this->hasOne('App\Models\Role', 'user_id');
    }

    public function restaurants()
    {
        return $this->belongsToMany('App\Models\Restaurant', 'restaurants_users');
    }

    public function orders()
    {
        return $this->hasMany('App\Models\Order', 'user_id');
    }

    public function restaurantFeedbacks()
    {
        return $this->hasMany('App\Models\RestaurantFeedback', 'user_id');
    }

    public function restaurantUserLikes()
    {
        return $this->belongsToMany('App\Models\Restaurant', 'restaurants_users_like', 'user_id', 'restaurant_id');
    }

    public function menuItemFeedbacks()
    {
        return $this->hasMany('App\Models\MenuItemFeedback', 'user_id');
    }

    public function menuItemUserLikes()
    {
        return $this->belongsToMany('App\Models\MenuItem', 'menu_items_users_like', 'user_id', 'menu_item_id');
    }

}